<?php
defined('ABSPATH') or die("Plugin-<a href='http://wp.vom-kuhberg.de'>Download</a>");
/**
	* Plugin Name:  viewsource
	* Plugin URI:   http://wp.vom-kuhberg.de
	* Description:  Quelltext-Anzeige mit Zeilennummern 
	* Version:      2019.06.07
	* Author:       Roberto Bosch 
	* Author URI:   http://wp.vom-kuhberg.de
	* Usage:        als ShortCode  [view_Source source='hallowelt.ino' brush='ino' ]
**/
function viewsource($atts)									// $atts ist ein Array mit den Attributen
{
	$plugin_url = plugin_dir_url( __FILE__ );
	wp_enqueue_style( 'style_viewSource' , $plugin_url . '_css/style.css' );  // Plugin-Style einbinden
	wp_enqueue_script('script_viewSource', $plugin_url . '_js/scripts.js' );  // Plugin-JS   einbinden
	$path_ico=$plugin_url."_img";                                             // Pfad zu ICONS ermitteln
	$s_source=$atts['source'];                                                // Uebergebener Quelltext-Name
	$s_brush=$atts['brush'] or $s_brush='cs';                                 // Quelltext-Icon
	if(file_exists("_src/".$s_source))
			{$as_lines=file("_src/".$s_source);} 
		else{$as_lines=array("// NO $s_source");}
	$i_rows=sizeof($as_lines);                                                // Anzahl der Zeilen des Quelltexts
	$ret ="<div id='viewSource'><img src='$path_ico/$s_brush.gif' />";        // QuellCode als DIV mit ICON
	$ret.="Source-Code <b>$s_source</b> ($i_rows Zeilen)<br/>";               // Ueberschrift fuer Quellcode
	$ret.="<script>svg_bar($i_rows);</script>";                               // Balken mit Anzahl an Zeilen
	$ret.="<table border=1><tr valign=top><td align=right><pre>";             // Quelltext als zwei Spaltige Tabelle
	for($r=1;$r<=$i_rows;$r++){$ret.="$r:\n";}                                // Zeilenummern
	$ret.="</pre></td><td><pre>";                                             // Zweite Spalte
	foreach($as_lines as $s){ $x=str_replace("<","&lt;",$s); $ret.=$x;}       // Quelltext-Zeilen 
	$ret.="</pre></td></tr></table></div>";                                   // Ende Tabelle und DIV
	return $ret;
}
add_shortcode('view_Source','viewSource');  // external Name for Shortcode, internal Name
?>