CREATE DATABASE IF NOT EXISTS bank_test;

USE bank_test;

CREATE TABLE tab_Forscher
	(
		Id            int auto_increment,
		Familienname  char(20),
		Vorname       char(15),
		Geburtsdatum  date,
		Geschlecht    char(1),
		Telefon       char(20),
		PRIMARY KEY   (Id)
	);



INSERT INTO tab_Forscher VALUES 
	(NULL, 'Einstein', 'Albert',      '1879-03-14', 'm', '14031879'),
	(NULL, 'Galilei',  'Galileo',     '1564-02-15', 'm', '15021564'),
	(NULL, 'Bosch',    'Robert',      '1861-09-23', 'm', '23091861'),
	(NULL, 'Nobel',    'Alfred',      '1833-10-21', 'm', '21101833'),
	(NULL, 'Ohm',      'Georg Simon', '1787-03-16', 'm', '16031787'),
	(NULL, 'Curie',    'Marie',       '1867-11-07', 'w', '07111867'),
	(NULL, 'Siemens',  'Werner von',  '1816-12-13', 'm', '13121816');




SELECT * FROM tab_Forscher;

SELECT Familienname,Vorname FROM tab_Forscher;

SELECT Familienname AS Name FROM tab_Forscher;

SELECT Familienname AS Name,Vorname,Geschlecht as Sex FROM tab_Forscher;

SELECT CONCAT(Familienname,', ',Vorname) AS Name FROM tab_Forscher;

SELECT 'Forscher' AS Title,TAB.* FROM tab_Forscher AS TAB;

SELECT * FROM tab_Forscher ORDER BY Familienname;

SELECT * FROM tab_Forscher ORDER BY Vorname;

SELECT * FROM tab_Forscher ORDER BY Geburtsdatum;

SELECT * FROM tab_Forscher ORDER BY RAND();

SELECT * FROM tab_Forscher ORDER BY RAND() LIMIT 1;

SELECT * FROM tab_Forscher WHERE Familienname LIKE '%i%';

SET @counter:=0;
SELECT (@counter := @counter +1) AS 'Nr', Familienname FROM tab_Forscher 
	WHERE Familienname LIKE '%i%';

SELECT * FROM tab_Forscher WHERE Vorname LIKE '%a%';

SELECT * FROM tab_Forscher WHERE Vorname LIKE 'A%';

SELECT * FROM tab_Forscher WHERE Familienname LIKE '%i%' AND Vorname LIKE '%a%';

SELECT * FROM tab_Forscher WHERE Familienname LIKE '%i%' OR Vorname LIKE '%a%';

SELECT * FROM tab_Forscher WHERE MONTH(Geburtsdatum)=11;


SELECT 
	YEAR(Geburtsdatum) as Jahr,Familienname,Vorname 
FROM 
	tab_Forscher 
WHERE
	YEAR(Geburtsdatum)>1800;


SELECT * FROM tab_Forscher ORDER BY RAND() LIMIT 1;


SELECT 
	Familienname, Vorname, Geburtsdatum, 
	IF ( (DAYOFYEAR(Geburtsdatum)-DAYOFYEAR(NOW()))<0,'vorbei','kommt') 
		AS Jahrestag
FROM tab_Forscher 
ORDER BY (DAYOFYEAR(Geburtsdatum)-DAYOFYEAR(NOW()));


SELECT Familienname, Vorname, Geburtsdatum, 
	IF((DAYOFYEAR(Geburtsdatum)AYOFYEAR(NOW()))<0,
365+DAYOFYEAR(Geburtsdatum),DAYOFYEAR(NOW()),
	DAYOFYEAR(Geburtsdatum)-DAYOFYEAR(NOW())) AS 'in n Tagen' 
	FROM tab_Forscher ORDER BY 'in n Tagen';


SELECT COUNT(*) AS Anzahl FROM tab_Forscher;


SELECT MID(Familienname,1,1) as ABC, 
	SUM( IF (Geschlecht='m',1,NULL)) as m,
	SUM( IF (Geschlecht='w',1,NULL)) as w 
	FROM tab_Forscher GROUP BY ABC;


SELECT MID(Vorname,1,1) as ABC, 
	SUM( IF (Geschlecht='m',1,NULL)) as m,
	SUM( IF (Geschlecht='w',1,NULL)) as w 
	FROM tab_Forscher GROUP BY ABC;
